/*
Copyright (c) 2015 by Matei Copot (http://codepen.io/towc/pen/ZGqPZE) modified by Boom Apps

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
*/

var w = c.width = window.innerWidth,
    h = c.height = window.innerHeight,
    ctx = c.getContext( '2d' ),
    opts = {
      spacing: 50,
      baseSize: 25,
      addedSize: 20,
      
      multX: .5,
      multY: 0.9,
      multSum: 0.1,
      tickSpeed: .01,
      hueMult: 0,
	  saturation: 100,
	  lightness: 65,
	  opacity:1,
	  hueFrom: 336,
	  hueMax: 51,
	  shape: "circle", //hexagon, circle, square
	  background: "#000000" 
    },
    
    tick = 0,
		rad = Math.PI / 6,
		sin = Math.sin( rad ),
		cos = Math.cos( rad ),
		xs,ys, drawPath;
		
function loop() {
  
  window.requestAnimationFrame( loop );
  ctx.fillStyle = opts.background;
  //ctx.clearRect( 0, 0, w, h );
  ctx.fillRect( 0, 0, w, h );
  
  tick += opts.tickSpeed;
  var addedHue = tick * opts.hueMult,
      difX = Math.sqrt( 3 ) * opts.spacing / 2,
      difY = opts.spacing * 3 / 2,
      limitX = c.width + opts.spacing,
      limitY = c.height + opts.spacing;
  
  for( var x = 0; x < limitX; x += difX*2 ){
		var i = 0;
    
    for( var y = 0; y < limitY; y += difY ){
			++i;
			
			var x1 = x + difX * ( i % 2 );
			xTimesMult = x1 * opts.multX,
			hueX = opts.hueFrom + x1 / limitX * opts.hueMax + tick * opts.hueMult,
      		size = opts.baseSize + opts.addedSize * Math.sin( ( xTimesMult + y * opts.multY ) * opts.multSum + tick );
      
			ctx.fillStyle = 'hsla(' + hueX + ',' + opts.saturation + '%,'+ opts.lightness +'%,'+opts.opacity+')';
			ctx.beginPath();
			
			switch (opts.shape) {
				case "circle":
					ctx.arc(x1, y, size, 0, 2 * Math.PI, false);
					
					drawPath = false;
				break;
				
				case "square":
					xs = [ -1, 1, 1, -1 ];
					ys = [ -1, -1, 1, 1 ];
					drawPath = true;
				break;
				case "hexagon":
					xs = [ cos, 0, -cos, -cos, 0, cos ];
					ys = [ -sin, -1, -sin, sin, 1, sin ];
					drawPath = true;
				break;
				case "triangle":	
					xs = [ .5, 1, 0 ];
					ys = [ 0, .8, .8 ];	
					drawPath = true;		
				break;
			}	
			
			if (drawPath) {
				ctx.moveTo( xs[0] * size + x1, ys[0] * size + y );
				for( var n = 1; n < xs.length; ++n ) {
					ctx.lineTo( xs[n] * size + x1, ys[n] * size + y );
				}
			}
			ctx.fill();
    }
  }
}
loop();

// just handlers and gui related stuff

window.addEventListener( 'resize', function(){
  
  w = c.width = window.innerWidth;
  h = c.height = window.innerHeight;
});


gui = new dat.GUI({	load: {
  "preset": "Blue Hex",
  "remembered": {
    "Smooth Circles": {
      "0": {
        "spacing": 50,
        "baseSize": 25,
        "addedSize": 20,
        "multX": 0.5,
        "multY": 0.9,
        "multSum": 0.1,
        "tickSpeed": 0.01,
        "hueMult": 0,
        "saturation": 100,
        "lightness": 65,
        "hueFrom": 336,
        "hueMax": 51,
        "opacity": 1,
        "shape": "circle",
        "background": "#ffffff"
      }
    },
    "UFO": {
      "0": {
        "spacing": 20.729892831131004,
        "baseSize": 0,
        "addedSize": 9.75444802830091,
        "multX": 0.7558006450941639,
        "multY": -0.41473311830194537,
        "multSum": 0.11647764714042957,
        "tickSpeed": 0.010838275587001012,
        "hueMult": 0, 
        "saturation": 100,
        "lightness": 45.52075746540425,
        "hueFrom": 74.13380501508692,
        "hueMax": 0,
        "opacity": 1,
        "shape": "hexagon",
        "background": "#132c59"
      }
    },
    "Blue Hex": {
      "0": {
        "spacing": 100,
        "baseSize": 72.61644643290678,
        "addedSize": 10.83827558700101,
        "multX": -0.1762910553879231,
        "multY": -0.5664689765199595,
        "multSum": -0.14,
        "tickSpeed": 0.032514826761003035,
        "hueMult": 0,
        "saturation": 99.71213540040931,
        "lightness": 14.089758263101315,
        "hueFrom": 206.7942981999793,
        "hueMax": 0,
        "opacity": 1,
        "shape": "hexagon",
        "background": "#001b34"
      }
    },
    "Dark Wave": {
      "0": {
        "spacing": 62.674019352824914,
        "baseSize": 24.928033850102327,
        "addedSize": 20.59272361530192,
        "multX": 0.9075365033121781,
        "multY": -0.067908299517913,
        "multSum": 0.0037595810356190196,
        "tickSpeed": 0.010838275587001012,
        "hueMult": 0,
        "saturation": 0,
        "lightness": 5.419137793500505,
        "hueFrom": 206.7942981999793,
        "hueMax": 0,
        "opacity": 1,
        "shape": "hexagon",
        "background": "#000000"
      }
    },
    "Triangle Wave": {
      "0": {
        "spacing": 62.674019352824914,
        "baseSize": 56.35903305240526,
        "addedSize": 21.67655117400202,
        "multX": 0.9075365033121781,
        "multY": -0.067908299517913,
        "multSum": 0.0037595810356190196,
        "tickSpeed": 0.010838275587001012,
        "hueMult": 0,
        "saturation": 0,
        "lightness": 91.0415149308085,
        "hueFrom": 0,
        "hueMax": 360,
        "opacity": 1,
        "shape": "triangle",
        "background": "#f2f2f2"
      }
    },
    "Colorful": {
      "0": {
        "spacing": 62.674019352824914,
        "baseSize": 19.50889605660182,
        "addedSize": 9.75444802830091,
        "multX": -0.5231158741719555,
        "multY": 0.5173585821801416,
        "multSum": 0.2,
        "tickSpeed": 0.010838275587001012,
        "hueMult": 50,
        "saturation": 71.53261887420668,
        "lightness": 53.10755037630496,
        "hueFrom": 0,
        "hueMax": 360,
        "opacity": 0.3901779211320364,
        "shape": "hexagon",
        "background": "#f2f2f2"
      }
    },
    "Boom Colors": {
      "0": {
        "spacing": 27.55800645094164,
        "baseSize": 7.586792910900709,
        "addedSize": 5.419137793500505,
        "multX": 0.2789165192661194,
        "multY": 0.04047445635209712,
        "multSum": -0.009246349668782183,
        "tickSpeed": 0.04335310234800405,
        "hueMult": 0,
        "saturation": 100,
        "lightness": 45.52075746540425,
        "hueFrom": 46.821350535844374,
        "hueMax": 0,
        "opacity": 1,
        "shape": "hexagon",
        "background": "#d40000"
      }
    }
  },
  "closed": false,
"folders": {}}});


gui.remember(opts);
gui.add( opts, 'spacing', 10, 100 );
gui.add( opts, 'baseSize', 0, 100 );
gui.add( opts, 'addedSize', 0, 100 );

gui.add( opts, 'multX', -1, 1 );
gui.add( opts, 'multY', -1, 1 );
gui.add( opts, 'multSum', -.2, .2 );
gui.add( opts, 'tickSpeed', 0, 1 );
gui.add( opts, 'hueMult', 0, 50 );
gui.add( opts, 'saturation', 0, 100 );
gui.add( opts, 'lightness', 0, 100 );
gui.add( opts, 'hueFrom', 0, 360 );
gui.add( opts, 'hueMax', 0, 360 );
gui.add( opts, 'opacity', 0, 1 );
gui.add( opts, 'shape', {'Circle' : 'circle','Hexagon' : 'hexagon', 'Square' : 'square', 'Triangle':'triangle'});
gui.addColor( opts, 'background', 'colorpicker');
